<?php

declare(strict_types=1);

namespace Erlage\Photogram;

use Exception;
use Tracy\Debugger;

class SystemDebugger
{
    public static function init()
    {
        Debugger::enable(MODE_DISPLAY_ERRORS ? Debugger::DEVELOPMENT : Debugger::PRODUCTION, DIR_PATH_LOG);

        if (MODE_DISPLAY_ERRORS)
        {
            try
            {
                Debugger::$scream = true;

                Debugger::$showBar = false;

                Debugger::$strictMode = true; // display all errors

                Debugger::$maxDepth = 12; // default: 7

                Debugger::$maxLength = 256; // default: 150

                Debugger::$dumpTheme = 'light'; // or: dark
            }
            catch (Exception $e)
            {
                Debugger::log($e, Debugger::ERROR);
            }
        }
    }
}
